package ppbot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 */
public class Main extends Agent {
    
    private int roundsNotMoving = 0;
    NeuralNetwork net = null;
    
    GeneticAlgorithm gA;
    final double alpha = 0.25;

    /** Creates a new instance of agent. */
    public Main() {
    }

    public enum Ray {
        
        STRAIGHT_AHEAD_300(1, new Triple(1, 0, 0), 300),
        
        STRAIGHT_AHEAD_200(3, new Triple(1, 0, 0), 200),

        LEFT45_200(2, new Triple(1, 1.25, 0), 225),
        
        RIGHT45_200(4, new Triple(1, -1.25, 0), 225);
        
        private int id;
        private Triple vector;
        private double length;
        
        private Ray(int id, Triple vector, double length) {
            this.id = id;
            this.vector = vector;
            this.length = length;
        }
        
        public int getId() {
            return id;
        }
        
        public Triple getVector() {
            return vector;
        }
        
        public double getLength() {
            return length;
        }
        
    }

    private class RayTraces implements RcvMsgListener {
        
        /**
         * Here we will store the last results of raycastings.
         * 
         *  Ray's ID -> result
         * (Integer  -> AutoTraceRay)
         */
        private Map<Integer, AutoTraceRay> traces = new HashMap<Integer, AutoTraceRay>();
        
        public RayTraces() {            
        }
        
        /**
         * This method will be called from doLogic() only once to initialize the object.
         */
        public void botInit() {
            log.info("RayTraces.botInit(): called");
            
            // tells the GameBots we want autotracing
            body.startAutoTrace();
            
            // remove default auto trace rays
            body.removeAllRaysFromAutoTrace();
            
            // now 1) register every ray inside GameBots and
            //     2) create initial value for every ray
            for (Ray ray : Ray.values()) {
                body.addRayToAutoTrace(ray.getId(), ray.getVector(), ray.getLength(), 
                                       false, // whether this is FastTrace ... NO we want full trace
                                              // to get HitNormal informations
                                       false  // whether we should trace the players and helaths as well
                                              // NO ... we want only walls, floors, etc.
                                      );
                traces.put(ray.getId(), new AutoTraceRay());
            }
            
            // register itself as a listener for ATR messages, so 
            // we can catch the AUTO_TRACE_RAY
            body.addTypedRcvMsgListener(this, MessageType.AUTO_TRACE_RAY);
            
            // now a little workarounds ...
            
            // we have to move a bot a bit to get first readings from rays
            body.moveInch();
            
            // now, to see only new rays (not the default ones), we have to switch
            // visibility of autotraces off and on again (with little delay)
            body.configureAutoTrace(false);
            try {
                Thread.sleep(200);
            } catch (InterruptedException ex) {               
            }
            body.configureAutoTrace(true);

        }

        /**
         * In this method we're receiving notices about ATR messages. It's
         * called every time when ATR message arrives.
         * @param e
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            // get the message from the event (casting it properly)
            AutoTraceRay ray = (AutoTraceRay)e.getMessage();
            try {
                // be synchronized with 'traces' to prevent concurrent read/write operations
                synchronized(traces) {
                    // insert the ray under it's number
                    // notice that ID goes under UnrealID field in the 'ray'
                    traces.put(Integer.parseInt(ray.UnrealID), ray);
                }
            } catch (Exception ex) {
                log.severe(ex.getMessage());
            }
        }
        
        
        /**
         * Returns info about one ray.
         * @param ray
         * @return
         */
        public AutoTraceRay getTrace(Ray ray) {
            synchronized(traces) {
                return traces.get(ray.getId());
            }            
        }
        
        /**
         * Returns the copy of the map of traces.
         * 
         * This will be useful for you when you will program the
         * control mechanism of the bot. You shouldn't rely on the getTrace()
         * because two calls of it may return different result (because of 
         * a two thread design of the bot).
         * 
         * @return current state of traces
         */
        public Map<Integer, AutoTraceRay> getTraceSnapshot() {
            synchronized(traces) {
                return new HashMap<Integer, AutoTraceRay>(traces);
            }
        }
        
    }
    
    private RayTraces traces = new RayTraces();
    
    private boolean init = true;
    
    private void init() {        
        // we're initializing the traces here
        traces.botInit();
    }
    
    
    private class LongTimeMemory extends LinkedList<Double>
    {
        public LongTimeMemory(int horizont) 
        {            
            for(int i=0; i<horizont; i++)
                add(new Double(0));
        }
    }
    
    LongTimeMemory longTimeMemory = new LongTimeMemory(3);
    
    protected void doLogic() {
        if (init) {
            init(); 
            init = false; 
        }
        
        Map<Integer, AutoTraceRay> rays = traces.getTraceSnapshot();
        for (AutoTraceRay ray : rays.values()) 
            log.info(ray.toString());
        
        if (rays.get(Ray.LEFT45_200.getId()).result)
            net.setInput(0, 1);
        else 
            net.setInput(0, -1);

        if (rays.get(Ray.RIGHT45_200.getId()).result)
            net.setInput(1, 1);
        else 
            net.setInput(1, -1);        
        
        if (rays.get(Ray.STRAIGHT_AHEAD_300.getId()).result)
            net.setInput(2, 1);
        else 
            net.setInput(2, -1);
        
        if (!memory.getAgentIsMoving()) 
            roundsNotMoving++; else roundsNotMoving = 0;

        net.setInput(3, roundsNotMoving > 3 ? 1 : -1);                
        
        net.setInput(4, 2 * net.getOutput(3) - 1);
        net.setInput(5, longTimeMemory.pop());

        net.compute();
        
        longTimeMemory.add(2 * net.getOutput(4) - 1);

        double angle = (net.getOutput(0) - net.getOutput(1));
        
        if (Math.abs(angle) > 0.08)
            body.turnHorizontal((int)(60*angle));
        else
        body.contMove((float)net.getOutput(2));        
        
        if (roundsNotMoving > 15)
        {
            roundsNotMoving = 0;
            body.respawn();            
        }
        
    }
    
    File botFile = new File("d:\\bestNet1.out");
    
    protected void prePrepareAgent() throws PogamutException 
    {
        int[] layers = {6,12,5};
        net = new NeuralNetwork(layers);        
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(botFile));
            net.deserialize(ois);
        } catch (Exception ex) {
            System.err.println("Error:"+ex.getMessage());
        }
    }

    protected void postPrepareAgent() throws PogamutException {
    /* Prepare logic according to information from gathered from startCommunication
    like choosing plan/parameters according to game type. */

    }

    protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent

    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}
